/*
 * Decompiled with CFR 0.152.
 */
package eu.ha3.presencefootsteps.sound.acoustics;

import com.google.common.base.Strings;
import eu.ha3.presencefootsteps.PresenceFootsteps;
import eu.ha3.presencefootsteps.sound.Options;
import eu.ha3.presencefootsteps.sound.State;
import eu.ha3.presencefootsteps.sound.acoustics.Acoustic;
import eu.ha3.presencefootsteps.sound.acoustics.AcousticLibrary;
import eu.ha3.presencefootsteps.sound.player.SoundPlayer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1309;

public class AcousticsPlayer
implements AcousticLibrary {
    private final SoundPlayer player;
    private final Map<String, Acoustic> acoustics = new HashMap<String, Acoustic>();

    public AcousticsPlayer(SoundPlayer player) {
        this.player = player;
    }

    @Override
    public void addAcoustic(String name, Acoustic acoustic) {
        this.acoustics.put(name, acoustic);
    }

    @Override
    public void playAcoustic(class_1309 location, String acousticName, State event, Options inputOptions) {
        if (acousticName.contains(",")) {
            List.of(acousticName.split(",")).stream().map(Strings::nullToEmpty).filter(s -> !s.isEmpty()).distinct().forEach(fragment -> this.playAcoustic(location, (String)fragment, event, inputOptions));
        } else if (!this.acoustics.containsKey(acousticName)) {
            PresenceFootsteps.logger.warn("Tried to play a missing acoustic: " + acousticName);
        } else {
            this.acoustics.get(acousticName).playSound(this.player, location, event, inputOptions);
        }
    }
}

